library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity fsmd is
  port( clk  : in  std_logic;
        rst  : in  std_logic;
        go   : in  std_logic;
        done : out std_logic);
end fsmd;

architecture bhv of fsmd is

  type STATE_TYPE is (S_START, S_COUNT, S_DONE);
  signal state, next_state : STATE_TYPE;
  signal count             : unsigned(3 downto 0);  
  constant MAX_COUNT_VAL : natural := 10;

begin

  process (clk, rst)
  begin
    if (rst = '1') then
      state <= S_START;
    elsif (clk = '1' and clk'event) then
      state <= next_state;
    end if;
  end process;

  -- tries to prevent infinite simulation loop by removing count from
  -- sensitivity list.
  -- but, by doing so, the simulation never leaves S_COUNT because neither
  -- state or go ever change. 
  
  process(go, state)
  begin

    case state is
      when S_START =>

        done  <= '0';
        count <= to_unsigned(1, count'length);

        if (go = '0') then
          next_state <= S_START;
        else
          next_state <= S_COUNT;
        end if;

      when S_COUNT =>

        done  <= '0';
        count <= count + 1;            

        if (count = MAX_COUNT_VAL) then
          next_state <= S_DONE;
        else
          next_state <= S_COUNT;
        end if;

      when S_DONE =>

        count      <= to_unsigned(MAX_COUNT_VAL, count'length);
        done       <= '1';
        next_state <= S_DONE;

      when others => null;
    end case;

  end process;
end bhv;
