library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity fsmd is
  port( clk  : in  std_logic;
        rst  : in  std_logic;
        go   : in  std_logic;
        done : out std_logic);
end fsmd;

architecture bhv of fsmd is

  type STATE_TYPE is (S_START, S_COUNT, S_DONE);
  signal state : STATE_TYPE;
  signal count : unsigned(3 downto 0);

  constant MAX_COUNT_VAL : natural := 10;

begin

  process (clk, rst)
  begin
    if (rst = '1') then
      state <= S_START;
      done  <= '0';
      count <= to_unsigned(0, count'length);

    elsif (clk = '1' and clk'event) then

      case state is
        when S_START =>

          done  <= '0';
          count <= to_unsigned(1, count'length);

          if (go = '0') then
            state <= S_START;
          else
            state <= S_COUNT;
          end if;

        when S_COUNT =>

          done  <= '0';
          count <= count + 1;

          if (count = MAX_COUNT_VAL) then
            state <= S_DONE;
          else
            state <= S_COUNT;
          end if;

        when S_DONE =>

          done  <= '1';
          state <= S_DONE;

        when others => null;
      end case;
    end if;
  end process;
end bhv;
