library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity tb is
end tb;

architecture behavior of tb is

  component fsmd
    port( clk  : in  std_logic;
          rst  : in  std_logic;
          go   : in  std_logic;
          done : out std_logic);
  end component;

  signal clk  : std_logic := '0';
  signal rst  : std_logic := '1';
  signal go   : std_logic := '0';
  signal done : std_logic;

begin

  UUT : fsmd port map (
    clk  => clk,
    rst  => rst,
    go   => go,
    done => done);

  clk <= not clk after 5 ns;

  process
  begin
    rst <= '1';
    go  <= '0';
    wait for 200 ns;

    rst <= '0';
    go  <= '1';
    wait;

  end process;

end;
